<?php get_header(); global $gp_settings; ?>

<?php gp_page_header( get_the_ID() ); ?>

<div id="content-wrapper"<?php if ( $gp_settings['layout'] != 'fullwidth' ) { ?> class="container"<?php } ?>>

	<?php if ( $gp_settings['filter'] == 'enable' ) { ?>
		<div id="portfolio-filters" class="portfolio-filters">
			<ul>
			   <li><a href="#" data-filter="*" class="gp-active"><?php echo __( 'All', 'gp_lang' ); ?></a></li>
				<?php 
				$terms = get_terms( 'gp_portfolios' );
				if ( !empty( $terms ) ) {
					foreach ( $terms as $term ) {
						echo '<li><a href="#" data-filter=".' . strtolower(preg_replace('/\s+/', '-', $term->slug ) ) . '">' . $term->name . '</a></li>';
					}
				}
				?>
			</ul>
		</div>
	<?php } ?><!-- END PORTFOLIO FILTERS -->

	<div id="content">
	
		<?php if ( have_posts() ) : ?>

			<div id="portfolio" class="portfolio-wrapper <?php echo $gp_settings['portfolio_type']; ?>">

				<?php while ( have_posts() ) : the_post(); ?>

					<?php 
					
					// Portfolio Categories
					$terms = get_the_terms( get_the_ID(), 'gp_portfolios' );
					$gp_portfolio_cats = null;
					if ( !empty( $terms ) ) {
						foreach ( $terms as $term ) {
							$gp_portfolio_cats .= strtolower( $term->slug ) . ' ';
						}
					} ?>

					<article <?php post_class( 'portfolio-loop ' . $gp_portfolio_cats . get_post_meta( get_the_ID(), '_gp_image_size', true ) ); ?> data-portfolio-cat="<?php echo $gp_portfolio_cats; ?>">

						<?php if( has_post_thumbnail() ) { ?>

							<div class="post-thumbnail">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
									
									<?php if ( $gp_settings['portfolio_type'] != 'portfolio-masonry' ) {
									
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 700, 500, true, false, true );
									
									} elseif ( get_post_meta( get_the_ID(), '_gp_image_size', true ) == 'wide' ) {
									
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 1000, 500, true, false, true );
										
									} elseif ( get_post_meta( get_the_ID(), '_gp_image_size', true ) == 'tall' ) {
									
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 500, 1000, true, false, true );
										
									} elseif ( get_post_meta( get_the_ID(), '_gp_image_size', true ) == 'large' ) {
										
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 1000, 1000, true, false, true );								
									
									} else {
									
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 500, 500, true, false, true );						
									
									} ?>
									
									<?php if ( $gp_retina == 'enable' ) {
										$retina = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), $image[1] * 2, $image[2] * 2, true, false, true );
									} else {
										$retina = '';
									} ?>
									
									<img src="<?php echo $image[0]; ?>" data-rel="<?php echo $retina[0]; ?>" width="<?php echo $image[1]; ?>" height="<?php echo $image[2]; ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ); } else { the_title_attribute(); } ?>" class="wp-post-image" />
												
								</a>
							</div>

						<?php } ?><!-- END FEATURED IMAGE -->

						<?php if ( $gp_settings['portfolio_type'] != 'portfolio-masonry' ) { ?>

							<header class="entry-header">

								<h2 class="loop-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>

							</header>
						
						<?php } ?>
						
					</article><!-- END PORTFOLIO ITEM -->

				<?php endwhile; ?>

			</div><!-- END PORTFOLIO WRAPPER -->

			<?php gp_pagination( $wp_query->max_num_pages ); ?>

		<?php else : ?>

			<span class="error"><?php _e( 'No portfolio items found.', 'gp_lang' ); ?></span>

		<?php endif; ?>

	</div><!-- END CONTENT -->

	<?php get_sidebar(); ?>

</div><!-- END CONTENT WRAPPER -->

<?php

// Column Number
if ( $gp_settings['portfolio_type'] == 'portfolio-columns-2' ) {
	$cols = 2;
} elseif ( $gp_settings['portfolio_type'] == 'portfolio-columns-3' ) {
	$cols = 3;
} elseif ( $gp_settings['portfolio_type'] == 'portfolio-columns-4' ) {
	$cols = 4;
} elseif ( $gp_settings['portfolio_type'] == 'portfolio-columns-5' ) {
	$cols = 5;
} elseif ( $gp_settings['portfolio_type'] == 'portfolio-columns-6' ) {
	$cols = 6;		
} else {
	$cols = 4;
} ?>

<script>		
jQuery( document ).ready( function( $ ) {

	'use strict';

	$( '#content' ).prepend( '<i class="loader portfolio-loader fa-spin"><i>' );

	var container = $( '#portfolio' );
	var element = container;

	if ( container.find( 'img' ).length == 0 ) {
		element = $( 'body' );
	}	

	imagesLoaded( element, function( instance ) {

		container.isotope({
			itemSelector: '.portfolio-loop',
			filter: '*',
			masonry: {
				<?php if ( $gp_settings['portfolio_type'] != 'portfolio-masonry' ) { ?>columnWidth: container.width() / <?php echo $cols; ?><?php } ?>
			}
		});

		$( '.portfolio-loader' ).stop( true, true ).fadeOut( 300 );

		container.find( '.portfolio-loop' ).css( 'opacity', 0 );
		container.find( '.portfolio-loop' ).each( function( i ) {
			$( this ).delay( i * 150 ).animate( { 'opacity': 1 }, 350 );
		});	

	});

	$( '#portfolio-filters ul li a' ).click( function() {

		var selector = $( this ).attr( 'data-filter' );
		container.isotope( { filter: selector } );

		$( '#portfolio-filters ul li a' ).removeClass( 'gp-active' );
		$( this ).addClass( 'gp-active' );

		return false;

	});

	$( '#portfolio-filters > a' ).click( function() {
		return false;
	});

	$( window ).smartresize( function() {
		container.isotope({
			masonry: {
				<?php if ( $gp_settings['portfolio_type'] != 'portfolio-masonry' ) { ?>columnWidth: container.width() / <?php echo $cols; ?><?php } ?>
			}
		});
	});

	
	/*--------------------------------------------------------------
	Remove portfolio filters not found on current page
	--------------------------------------------------------------*/
	
	if ( $( 'div' ).hasClass( 'portfolio-filters' ) ) {
	
		var isotopeCatArr = [];
		var $portfolioCatCount = 0;
		$( '.portfolio-filters ul li' ).each( function( i ) {
			if ( $( this ).find( 'a' ).length > 0 ) {
				isotopeCatArr[$portfolioCatCount] = $( this ).find( 'a' ).attr( 'data-filter' ).substring( 1 );	
				$portfolioCatCount++;
			}
		});
	
		isotopeCatArr.shift();
	
		var itemCats = '';
	
		$( '.portfolio-wrapper > .portfolio-loop' ).each( function( i ) {
			itemCats += $( this ).attr( 'data-portfolio-cat' );
		});
		itemCats = itemCats.split( ' ' );
	
		itemCats.pop();
		
		itemCats = $.unique( itemCats );
	
		var notFoundCats = [];
		$.grep( isotopeCatArr, function( el ) {
			if ( $.inArray(el, itemCats ) == -1 ) {
				notFoundCats.push( el  );
			}
		});
	
		if(notFoundCats.length != 0 ) {
			$( '.portfolio-filters ul li' ).each( function() {
				if ( $( this ).find( 'a' ).length > 0 ) {
					if( $.inArray( $( this ).find( 'a' ).attr( 'data-filter' ).substring( 1 ), notFoundCats ) != -1 ) {
						$( this ).hide();
					}
				}
			});
		}
	
	}
		
});			
</script>

<?php get_footer(); ?>