<?php require( gp_inc . 'options.php' ); global $gp_settings;

// Get Post Tags
$tags = wp_get_post_tags( get_the_ID() );
$tempQuery = $wp_query;

if ( $tags ) {

	$tag_ids = array();

	foreach ( $tags as $individual_tag ) $tag_ids[] = $individual_tag->term_id;

	$args = array(
	'post_type'           => 'post',
	'ignore_sticky_posts' => 0,
	'orderby'             => 'rand',
	'order'               => 'asc',
	'paged'               => 1,
	'posts_per_page'      => $gp_settings['related_per_page'],
	'offset'              => 0,
	'tag__in'             => $tag_ids,
	'post__not_in'        => array( get_the_ID() ),
	); 

	$featured_query = new wp_query( $args ); if ( $featured_query->have_posts() ) :
	
	// Column Width
	$column_width = ( 100 - ( ( $gp_settings['related_per_page'] * 4 ) - 4 ) ) / $gp_settings['related_per_page'];
		
	?>
	
		<div class="related-posts">
		
			<span class="border-triangle"></span>

			<header class="related-posts-title">
				<h3><?php echo _e( 'Related Posts', 'gp_lang' ); ?></h3>
			</header><!-- END HEADER -->
	
			<?php while ( $featured_query->have_posts() ) : $featured_query->the_post(); ?>

				<article <?php post_class( 'post-loop' ); ?> style="width: <?php echo $column_width; ?>%;">
	
					<div class="post-thumbnail">
				
						<a href="<?php the_permalink(); ?>">	
									
							<?php if ( has_post_thumbnail() ) { ?>	
							
								<?php $image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), $gp_settings['related_image_width'], $gp_settings['related_image_height'], true, false, true ); ?>
								
								<?php if ( $gp_retina == 'enable' ) {
									$retina = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), $gp_settings['related_image_width'] * 2, $gp_settings['related_image_height'] * 2, true, false, true );
								} else {
									$retina = "";
								} ?>
								
								<img src="<?php echo $image[0]; ?>" data-rel="<?php echo $retina[0]; ?>" width="<?php echo $image[1]; ?>" height="<?php echo $image[2]; ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ); } else { the_title_attribute(); } ?>" class="wp-post-image" />	

							<?php } else { ?>

								<?php if ( get_post_format() == 'video' ) { 
									$post_format_class = 'fa-video-camera';
								} elseif ( get_post_format() == 'audio' ) {
									$post_format_class = 'fa-music';
								} elseif ( get_post_format() == 'gallery' ) {
									$post_format_class = 'fa-picture-o';
								} elseif ( get_post_format() == 'quote' ) {
									$post_format_class = 'fa-quote-right';
								} else {
									$post_format_class = 'fa-file-o';
								} ?>
										
								<i class="no-thumbnail fa fa-3x <?php echo $post_format_class; ?>" width="<?php echo $gp_settings['related_image_width']; ?>" height="<?php echo $gp_settings['related_image_height']; ?>" style="width: <?php echo $gp_settings['related_image_width']; ?>px; height: <?php echo $gp_settings['related_image_height']; ?>px; line-height: <?php echo $gp_settings['related_image_height']; ?>px;"></i>
															
							<?php } ?>
						
						</a>
								
					</div><!-- END FEATURED IMAGE -->

					<strong><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php echo the_title(); ?></a></strong>
				
					<div class="entry-meta">							
						<span class="meta-date"><?php the_time( get_option( 'date_format' ) ); ?></span>
					</div>

				</article><!-- END POST -->
		
			<?php endwhile; ?>
	
		</div><!-- END RELATED POSTS -->

	<?php endif; wp_reset_postdata(); ?>

<?php } ?>