<?php require( gp_inc . 'options.php' ); global $gp_settings, $post; ?>

<article <?php post_class( 'post-loop' ); ?>>

	<?php if ( get_post_format() != 'quote' ) { ?>

		<header class="entry-header">

			<h2 class="loop-title"><a href="<?php if ( get_post_format() == 'link' ) { echo get_post_meta( get_the_ID(), '_gp_link', true) ; } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>" target="<?php if ( get_post_format() == 'link' ) { echo get_post_meta( get_the_ID(), '_gp_link_target', true ); } ?>"><?php the_title(); ?></a></h2>

			<?php if ( $gp_settings['meta_date'] == 'enable' OR $gp_settings['meta_author'] == 'enable' OR ( $gp_settings['meta_cats'] == 'enable' && $post->post_type == 'post' ) OR $gp_settings['comments'] == 'enable' ) { ?>

				<div class="entry-meta">

					<?php if ( $gp_settings['meta_author'] == 'enable' ) { ?><span class="meta-author"><?php the_author_posts_link(); ?></span><?php } ?>

					<?php if( $gp_settings['meta_date'] == 'enable' ) { ?><span class="meta-date"><?php the_time( get_option( 'date_format' ) ); ?></span><?php } ?>

					<?php if( $gp_settings['meta_cats'] == 'enable' && $post->post_type == 'post' ) { ?><span class="meta-cats"><?php the_category( ', ' ); ?></span><?php } ?>	

					<?php if( $gp_settings['meta_comments'] == 'enable' ) { ?><span class="meta-comments"><?php comments_popup_link( __( 'No Comments', 'gp_lang' ), __( '1 Comment', 'gp_lang' ), __( '% Comments', 'gp_lang' ), 'comments-link', __( 'Comments Closed', 'gp_lang' ) ); ?></span><?php } ?>
								
				</div>

			<?php } ?><!-- END ENTRY META -->

		</header>

	<?php } ?><!-- END ENTRY HEADER -->

	<?php if ( has_post_thumbnail() && $gp_settings['featured_image'] == 'enable' && get_post_format() == '0' ) { ?>

		<div class="post-thumbnail<?php if ( $gp_settings['image_wrap'] == 'enable' ) { ?> wrap<?php } ?>">

			<?php $image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ),  $gp_settings['image_width'], $gp_settings['image_height'], $gp_settings['hard_crop'], false, true ); ?>
			<?php if ( $gp_retina == 'enable' ) {
				$retina = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ),  $gp_settings['image_width'] * 2, $gp_settings['image_height'] * 2, $gp_settings['hard_crop'], false, true );
			} else {
				$retina = '';
			} ?>
			
			<a href="<?php echo the_permalink(); ?>">
				<img src="<?php echo $image[0]; ?>" data-rel="<?php echo $retina[0]; ?>" width="<?php echo $image[1]; ?>" height="<?php echo $image[2]; ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ); } else { the_title_attribute(); } ?>" class="wp-post-image" />
			</a>
					
		</div>

	<?php } ?>
		
	<?php get_template_part( 'entry', get_post_format() ); ?>

	<?php if ( $post->post_type == 'page' OR get_post_format() == '0' OR get_post_format() == 'audio' OR (get_post_format() == 'gallery' && ! has_shortcode( $post->post_content, 'gallery' ) )  OR get_post_format() == 'link' OR get_post_format() == 'video' ) { ?>

		<div class="entry-content">

			<?php if ( $gp_settings['content_display'] == 'full_content' ) { ?>

				<?php global $more; $more = 0; the_content( '[' . __( 'Read More', 'gp_lang' ) . ']' ); ?>

			<?php } else { ?>

				<?php if ( $gp_settings['excerpt_length'] != '0' ) { ?>
					<p><?php echo gp_excerpt( $gp_settings['excerpt_length'] ); ?></p>
				<?php } ?>

			<?php } ?>

			<?php if ( $gp_settings['meta_tags'] == 'enable' ) { ?>
				<?php the_tags( '<div class="meta-tags">', ' ', '</div>' ); ?>
			<?php } ?>
			
		</div><!-- END ENTRY CONTENT -->
	
	<?php } ?>	

</article><!-- END POST -->