jQuery( document ).ready( function( $ ) {

	'use strict';

	/*--------------------------------------------------------------
	Screen size class
	--------------------------------------------------------------*/

	function gpScreenSizeClass() {
		if ( $(window).innerWidth() <= 982 && $( 'body' ).hasClass( 'gp-responsive' ) ) {
			$( 'body' ).addClass( 'gp-mobile' ).removeClass( 'gp-desktop' ).removeClass( 'gp-tablet' );
		} else if ( $(window).innerWidth() <= 1082 && $( 'body' ).hasClass( 'gp-responsive' ) ) {
			$( 'body' ).addClass( 'gp-tablet' ).removeClass( 'gp-desktop' ).removeClass( 'gp-mobile' );	
		} else {
			$( 'body' ).removeClass( 'gp-mobile' ).removeClass( 'gp-tablet' ).addClass( 'gp-desktop' );
		}
	}
	
	gpScreenSizeClass();
	$( window ).resize( gpScreenSizeClass );


	/*--------------------------------------------------------------
	Slide up/down mobile navigation
	--------------------------------------------------------------*/

	function gpMobileNav() {

		$( '#mobile-nav-button' ).toggle( function() {
			$( '#mobile-nav' ).slideDown();
			$( '#mobile-nav-button' ).addClass( 'gp-active' );
		}, function() {
			$( '#mobile-nav' ).slideUp();
			$( '#mobile-nav-button' ).removeClass( 'gp-active' );
		});
		
	}
	
	gpMobileNav();
	$( window ).resize( gpMobileNav );
	

	/*--------------------------------------------------------------
	Toggle search form
	--------------------------------------------------------------*/

	function gpSearchForm() {
	
		$( '#mobile-search' ).show();

		$( '#search-button' ).toggle(function() {
			$( '#search-button' ).addClass( 'gp-active' );
			$( '.gp-header-1 #desktop-search, .gp-header-3 #desktop-search, .gp-header-4 #desktop-search' ).slideDown();
			$( '.gp-header-2 #desktop-search' ).fadeIn( 'slow' );		
		}, function() {
			$( '#search-button' ).removeClass( 'gp-active' );
			$( '.gp-header-1 #desktop-search, .gp-header-3 #desktop-search, .gp-header-4 #desktop-search' ).slideUp();
			$( '.gp-header-2 #desktop-search' ).fadeOut( 'slow' );
		});

	}	

	gpSearchForm();
	$( window ).resize( gpSearchForm );
			
		
	/*--------------------------------------------------------------
	Smooth scroll
	--------------------------------------------------------------*/

	if ( $( 'body' ).hasClass( 'gp-smooth-scrolling' ) && $( window ).width() > 767 && $( 'body' ).outerHeight( true ) > $( window ).height() ) {
		$( 'html' ).niceScroll({
			scrollspeed: 100,
			mousescrollstep: 40,
			cursorwidth: 10,
			cursorborder: '0',
			zindex: 10000,
			cursoropacitymin: 0,
			cursoropacitymax: 0.6
		});
	}
		

	/*--------------------------------------------------------------
	Dropdown Hover Effect
	--------------------------------------------------------------*/

	$( '.nav > ul > li' ).hover(
		function() {
			$( this ).children( '.sub-menu' ).stop().animate( { opacity: 1 }, 600 );
		},
		function() {
			$( this ).children( '.sub-menu' ).stop().animate( { opacity: 0 }, 600 );
		}
	);
	

	/*--------------------------------------------------------------
	Parallax Effect
	--------------------------------------------------------------*/

	if( $( 'div' ).hasClass( 'gp-parallax' ) || $( 'header' ).hasClass( 'gp-parallax' ) ) {
		$( window ).stellar( {
			responsive: true,
			horizontalScrolling: false
		});
	}
		
		
	/*--------------------------------------------------------------
	Masonry blog
	--------------------------------------------------------------*/

	if ( $( '.post-wrapper' ).hasClass( 'blog-masonry' ) ) {
	
		var container = $( '.blog-masonry' );
		var cols = 3;
		var element = container;

		if ( container.find( 'img' ).length == 0 ) {
			element = $( '<img />' );
		}	

		imagesLoaded( element, function( instance ) {

			if ( $( 'body' ).hasClass( 'gp-mobile' ) || ( !$( 'body' ).hasClass( 'fullwidth' ) && !$( 'body' ).hasClass( 'no-sidebar' ) ) ) {
				cols = 2;
			}

			container.isotope({
				itemSelector: '.hentry',
				masonry: {
					columnWidth: container.width() / cols
				}
			});

			container.animate( { 'opacity': 1 }, 1300 );
			$( 'ul.page-numbers' ).animate( { 'opacity': 1 }, 1300 );

			$( window ).trigger( 'resize' );

		});

		$( window ).resize( function() {
			if ( $( 'body' ).hasClass( 'gp-mobile' ) || ( !$( 'body' ).hasClass( 'fullwidth' ) && !$( 'body' ).hasClass( 'no-sidebar' ) ) ) {
				cols = 2;
			} else {
				cols = 3;
			}
		});

		$( window ).smartresize( function() {
			container.isotope({
			masonry: {
				columnWidth: container.width() / cols
			}
			});
		});
	
	}

		
	/*--------------------------------------------------------------
	Remove gallery shortcode when gallery slider active 
	--------------------------------------------------------------*/

	$( '.gallery-slider-active .gallery' ).remove();
	
	
	/*--------------------------------------------------------------
	Back to top button
	--------------------------------------------------------------*/

	if ( $( 'body' ).hasClass( 'gp-back-to-top' ) ) {
		$().UItoTop({ 
			text: '<i class="fa fa-chevron-up"></i>',
			scrollSpeed: 600
		});
	}
		

	/*--------------------------------------------------------------
	prettyPhoto lightbox
	--------------------------------------------------------------*/

	$(' a[rel^="prettyPhoto"]' ).prettyPhoto({
		theme: 'pp_default',
		deeplinking: false,
		social_tools: '',
		default_width: '768'
	});
	
		
	/*--------------------------------------------------------------
	Related post image height
	--------------------------------------------------------------*/

	function gpRelatedImages() {
		$( '.related-posts .no-thumbnail' ).css({
			height: $( '.related-posts img' ).height(),
			lineHeight: parseInt( $( '.related-posts img' ).height() ) + 'px'
		});	
	}
	
	gpRelatedImages();
	$( window ).resize( gpRelatedImages );
	

	/*--------------------------------------------------------------
	Remove WooCommerce Comment Meta Dash 
	--------------------------------------------------------------*/

	$( '.comment-text .meta' ).html( function( index, text ) {
		return text.replace( '–', '' );
	});


	/*--------------------------------------------------------------
	WooCommerce image overlay 
	--------------------------------------------------------------*/

	$( '.product-image-container .image-overlay' ).css( 'opacity', 0 ).hover( function() {
		$( this ).fadeTo( 'fast', 1 );
	}, function() {
		$( this ).fadeTo( 'fast', 0 );
	});	


	/*--------------------------------------------------------------
	Set slider height to auto 
	--------------------------------------------------------------*/

	$( window ).load( function() {
		if ( $(window).innerWidth() > 1082 ) {
			$( '#homepage-slider' ).css( 'height', 'auto' );	
		}
	});
	

	/*--------------------------------------------------------------
	Resize header
	--------------------------------------------------------------*/

	function gpResizeHeader() {

		// Defaults Before Scrolling
	
		if ( $( window ).innerWidth() <= 982 && $( 'body' ).hasClass( 'gp-responsive' ) ) {

			$( '#header' ).data( 'size', 'small' ).addClass( 'header-small' ).removeClass( 'header-large' );

			$( '.gp-header-2 #mobile-nav' ).css({
				marginTop: parseInt( gp_script.headerHeight ) / gp_script.headerSizeReduction
			});
		
		} else {
	
			$( '#header' ).data( 'size', 'large' ).addClass( 'header-large' ).removeClass( 'header-small' );
							
			$( '.gp-header-2 #desktop-search' ).css({
				marginTop: parseInt( gp_script.headerHeight ) + 40
			});
					
		}
	
		// Upon Scrolling
	
		$( window ).scroll( function() {
		
			if ( $( 'body' ).hasClass( 'gp-desktop' ) && $( 'body' ).hasClass( 'gp-fixed-header' ) && $( 'body' ).hasClass( 'gp-header-resize' ) ) {

				if ( $( document ).scrollTop() > 0) {

					if ( $( '#header' ).data( 'size' ) == 'large' )  {
			
						$('body').not( '.gp-header-4' ).find( '#header' ).data( 'size', 'small' ).addClass( 'header-small' ).removeClass( 'header-large' ).stop().animate({
							height: parseInt( gp_script.headerHeight ) / gp_script.headerSizeReduction
						}, 300 );
					
						$('body').not( '.gp-header-4' ).find( '#header .menu > li > a, #search-button, #cart-button, .mobile-button' ).stop().animate({
							lineHeight: parseInt( gp_script.headerHeight ) / gp_script.headerSizeReduction
						}, 300 );

						$( '.gp-header-4 #header' ).data( 'size', 'small' ).addClass( 'header-small' ).removeClass( 'header-large' ).stop().animate({
							height: ( parseInt( gp_script.headerHeight ) / gp_script.headerSizeReduction ) + ( parseInt( gp_script.navLineHeight ) / gp_script.headerSizeReduction )
						}, 300 );
					
						$( '.gp-header-4 #header .menu > li > a, .gp-header-4 #search-button, .gp-header-4 #cart-button, .gp-header-4 .mobile-button' ).stop().animate({
							lineHeight: ( parseInt( gp_script.navLineHeight ) / gp_script.headerSizeReduction )
						}, 300 );
																	
						$( '#header #logo' ).stop().animate({
							marginTop: parseInt( gp_script.logoMarginTop ) / gp_script.headerSizeReduction,
							marginBottom: parseInt( gp_script.logoMarginBottom ) / gp_script.headerSizeReduction
						}, 300 ); 
					
						$( '#header #logo img' ).stop().animate({
							height: parseInt( gp_script.logoHeight ) / gp_script.headerSizeReduction
						}, 300 ); 
								
						$( '.gp-header-1 #fixed-header-padding' ).stop().animate({
							paddingTop: parseInt( gp_script.headerHeight ) / gp_script.headerSizeReduction
						}, 400 );
					
						$( '.gp-header-3 #fixed-header-padding' ).stop().animate({
							paddingTop: (parseInt( gp_script.headerHeight ) / gp_script.headerSizeReduction ) + parseInt( $( '#top-header' ).height() )
						}, 400 );

						$( '.gp-header-4 #fixed-header-padding' ).stop().animate({
							paddingTop: ( parseInt( gp_script.headerHeight ) / gp_script.headerSizeReduction ) + ( parseInt( gp_script.navLineHeight ) / gp_script.headerSizeReduction )
						}, 400 );
										
						$( '#desktop-search' ).css({
							position: 'fixed'
						});
					
						$( '.gp-header-2 #desktop-search' ).stop().animate({
							marginTop: parseInt( gp_script.headerHeight ) / gp_script.headerSizeReduction
						}, 400 );
								
					}

				} else {

					if ( $( '#header' ).data( 'size' ) == 'small' ) {
			
						$('body').not( '.gp-header-4' ).find( '#header' ).data( 'size', 'large' ).addClass( 'header-large' ).removeClass( 'header-small' ).stop().animate({
							height: gp_script.headerHeight
						}, 300 );
					
						$('body').not( '.gp-header-4' ).find( '#header .menu > li > a, #search-button, #cart-button, .mobile-button' ).stop().animate({
							lineHeight: gp_script.headerHeight
						}, 300 );

						$( '.gp-header-4 #header' ).data( 'size', 'large' ).addClass( 'header-large' ).removeClass( 'header-small' ).stop().animate({
							height: parseInt( gp_script.headerHeight ) + parseInt( gp_script.navLineHeight )
						}, 300 );
					
						$( '.gp-header-4 #header .menu > li > a, .gp-header-4 #search-button, .gp-header-4 #cart-button, .gp-header-4 .mobile-button' ).stop().animate({
							lineHeight: parseInt( gp_script.navLineHeight )
						}, 300 );			
											 
						$( '#header #logo' ).stop().animate({
							marginTop: parseInt( gp_script.logoMarginTop ),
							marginBottom: parseInt( gp_script.logoMarginBottom )
						}, 300 ); 
					
						$( '#header #logo img' ).stop().animate({
							height: parseInt( gp_script.logoHeight )
						}, 300 );
					
						$( '.gp-header-1 #fixed-header-padding' ).stop().animate({
							paddingTop: parseInt( gp_script.headerHeight )
						}, 400 );
						
						$( '.gp-header-3 #fixed-header-padding' ).stop().animate({
							paddingTop: parseInt( gp_script.headerHeight ) + parseInt( $( '#top-header' ).height() )
						}, 400 );    

						$( '.gp-header-4 #fixed-header-padding' ).stop().animate({
							paddingTop: parseInt( gp_script.headerHeight ) + parseInt( gp_script.navLineHeight )
						}, 400 );
										
						$( '.gp-header-1 #desktop-search, .gp-header-3 #desktop-search, .gp-header-4 #desktop-search' ).css({
							position: 'relative'
						});
					
						$( '.gp-header-2 #desktop-search' ).css({
							position: 'absolute'
						});
					
						$( '.gp-header-2 #desktop-search' ).stop().animate({
							marginTop: parseInt( gp_script.headerHeight ) + 40
						}, 400 );
									 
					}
				}
					
			}

		});

	}

	gpResizeHeader();
	$( window ).resize( gpResizeHeader );

});