<?php

add_action( 'widgets_init', 'gp_recent_posts' );

function gp_recent_posts() {
	register_widget( 'GP_Recent_Posts' );
}

class GP_Recent_Posts extends WP_Widget {
	
	function GP_Recent_Posts() {
		$widget_ops = array( 'classname' => 'gp-recent-posts', 'description' => __( 'Your site\'s most recent Posts. with thumbnails.', 'gp_lang' ) );
		$this->WP_Widget( 'gp-recent-posts-widget', __( 'GP Recent Posts', 'gp_lang' ), $widget_ops );
	}

	function widget( $args, $instance ) {
		
		global $date_range;
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );		
		$posts = $instance['posts'];
		$show_date = $instance['show_date'];

		require( gp_inc . 'options.php' ); global $gp_settings;
	
		echo $before_widget;	
			
		?>

		<?php if ( $title ) { echo $before_title . $title . $after_title; } ?>

		<div class="posts-wrapper">
	
			<?php 

			$args = array( 
			'post_type'      => 'post',
			'posts_per_page' => $posts,
			);

			$featured_query = new wp_query( $args ); if ( $featured_query->have_posts() ) : ?>
			
				<?php while ( $featured_query->have_posts() ) : $featured_query->the_post(); ?>
	
					<article <?php post_class( 'post-loop' ); ?>>

						<div class="post-thumbnail">
							
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">

								<?php if ( has_post_thumbnail() ) { ?>
								
									<?php $image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 55, 55, true, false, true ); ?>
									<?php if ( $gp_retina == 'enable' ) {
										$retina = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 55 * 2, 55 * 2, true, false, true );
									} else {
										$retina = '';
									} ?>
									
									<img src="<?php echo $image[0]; ?>" data-rel="<?php echo $retina[0]; ?>" width="<?php echo $image[1]; ?>" height="<?php echo $image[2]; ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ); } else { the_title_attribute(); } ?>" class="wp-post-image" />
									
								<?php } else { ?>
								
									<?php if ( get_post_format() == 'video' ) { 
										$post_format_class = 'fa-video-camera';
									} elseif ( get_post_format() == 'audio' ) {
										$post_format_class = 'fa-music';
									} elseif ( get_post_format() == 'gallery' ) {
										$post_format_class = 'fa-picture-o';
									} elseif ( get_post_format() == 'quote' ) {
										$post_format_class = 'fa-quote-left';
									} else {
										$post_format_class = 'fa-file-o';
									} ?>
									
									<i class="no-thumbnail fa fa-lg <?php echo $post_format_class; ?>"></i>	
								
								<?php } ?>
																									
							</a>
							
						</div><!-- END FEATURED IMAGE -->

						<strong><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></strong>
						
						<?php if ( $show_date ) { ?>
							<div class="entry-meta">
								<span class="meta-date"><?php the_time( get_option( 'date_format' ) ); ?></span>				
							</div>
						<?php } ?>
						
					</article><!-- END POST -->

				<?php endwhile; else : ?>
		
				<?php _e( 'There are no posts to display.', 'gp_lang' ); ?>
		
			<?php endif; wp_reset_postdata(); ?>
							
		</div><!-- END POSTS WRAPPER -->		

		<?php echo $after_widget; 

	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['posts'] = $new_instance['posts'];
		$instance['show_date'] = $new_instance['show_date'];				
		return $instance;
	}

	function form( $instance ) {
		
		$defaults = array( 
			'title'     => 'Recent Posts',
			'posts'     => 5,
			'show_date' => 1,
		 ); $instance = wp_parse_args( ( array ) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'gp_lang' ); ?></label>
			<br/><input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'posts' ); ?>"><?php _e( 'Number of posts to show:', 'gp_lang' ); ?></label> <input type="text" id="<?php echo $this->get_field_id( 'posts' ); ?>" name="<?php echo $this->get_field_name( 'posts' ); ?>" value="<?php echo $instance['posts']; ?>" size="3" />
		</p>
		

		<p>
			<input type="checkbox" id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" value="1" <?php checked( $instance['show_date'], 1 ); ?>  /><label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php _e( 'Display post date?', 'gp_lang' ); ?></label>
		</p>
							
		<input type="hidden" name="widget-options" id="widget-options" value="1" />

		<?php

	}
}

?>