<?php // Meta Options (WPShout.com)

require( gp_inc . 'options.php' );

add_action( 'admin_menu', 'gp_create_meta_box' );
add_action( 'save_post', 'gp_save_meta_data' );

function gp_create_meta_box() {
	add_meta_box( 'gp-theme-options', __( 'Post Settings', 'gp_lang' ), 'gp_meta_boxes', 'post', 'normal', 'core' );
	add_meta_box( 'gp-theme-options', __( 'Page Settings', 'gp_lang' ), 'gp_meta_boxes', 'page', 'normal', 'core' );
	add_meta_box( 'gp-theme-options', __( 'Portfolio Settings', 'gp_lang' ), 'gp_meta_boxes', 'gp_portfolio_item', 'normal', 'core' );	
	add_meta_box( 'gp-theme-options', __( 'Product Settings', 'gp_lang' ), 'gp_meta_boxes', 'product', 'normal', 'core' );	
	add_meta_box( 'gp-theme-options', __( 'Slide Settings', 'gp_lang' ), 'gp_meta_boxes', 'gp_slide', 'normal', 'core' );			
}


/////////////////////////////////////// Post Settings ///////////////////////////////////////


function gp_post_meta_boxes() {
	
	$meta_boxes = array( 


	'audio_format_settings' => array( 'name' => 'audio_format_settings', 'type' => 'open', 'title' => __( 'Audio Post Format Settings', 'gp_lang' ), 'desc' => __( 'Controls the audio post format.', 'gp_lang' ) ),

		'_gp_audio_mp3_url' => array( 'name' => '_gp_audio_mp3_url', 'title' => __( 'MP3 Audio URL', 'gp_lang' ), 'type' => 'upload' ),

	array( 'type' => 'close' ),

			
	'gallery_format_settings' => array( 'name' => 'gallery_format_settings', 'type' => 'open', 'title' => __( 'Gallery Post Format', 'gp_lang' ), 'desc' => __( 'Controls the gallery post format.', 'gp_lang' ) ),
	
		'_gp_gallery_slider' => array( 'name' => '_gp_gallery_slider', 'title' => __( 'Gallery Slider', 'gp_lang' ), 'type' => 'gallery_upload' ),
								
	array( 'type' => 'close' ),
	
	
	'link_format_settings' => array( 'name' => 'link_format_settings', 'type' => 'open', 'title' => __( 'Link Post Format Settings', 'gp_lang' ), 'desc' => __( 'Controls the link post format.', 'gp_lang' ) ),

		'_gp_link' => array( 'name' => '_gp_link', 'title' => __( 'Link', 'gp_lang' ), 'type' => 'text', 'std' => 'http://' ),
		
		'_gp_link_target' => array( 'name' => '_gp_link_target', 'title' => __( 'Link Target', 'gp_lang' ), 'type' => 'radio', 'options' => array( '_blank' => __( 'New Window', 'gp_lang' ), '_self' => __( 'Same Window', 'gp_lang' ) ), 'std' => '_blank' ),
								
	array( 'type' => 'close' ),


	'quote_format_settings' => array( 'name' => 'quote_format_settings', 'type' => 'open', 'title' => __( 'Quote Post Format Settings', 'gp_lang' ), 'desc' => __( 'Controls the quote post format.', 'gp_lang' ) ),

		'_gp_quote_source' => array( 'name' => '_gp_quote_source', 'title' => __( 'Quote Source', 'gp_lang' ), 'type' => 'text', 'std' => '' ),
								
	array( 'type' => 'close' ),
	
	
	'video_format_settings' => array( 'name' => 'video_format_settings', 'type' => 'open', 'title' => __( 'Video Post Format Settings', 'gp_lang' ), 'desc' => __( 'Controls the video post format.', 'gp_lang' ) ),

		'_gp_video_embed_url' => array( 'name' => '_gp_video_embed_url', 'title' => __( 'Video URL', 'gp_lang' ), 'desc' => __( 'Video URL uploaded to one of the major video sites e.g. YouTube, Vimeo, blip.tv, etc.', 'gp_lang' ), 'type' => 'text' ),

		'_gp_video_m4v_url' => array( 'name' => '_gp_video_m4v_url', 'title' => __( 'M4V Video URL', 'gp_lang' ), 'type' => 'upload' ),
		
		'_gp_video_mp4_url' => array( 'name' => '_gp_video_mp4_url', 'title' => __( 'MP4 Video URL', 'gp_lang' ), 'type' => 'upload' ),

		'_gp_video_webm_url' => array( 'name' => '_gp_video_webm_url', 'title' => __( 'WebM Video URL', 'gp_lang' ), 'type' => 'upload' ),
		
		'_gp_video_ogv_url' => array( 'name' => '_gp_video_ogv_url', 'title' => __( 'OGV Video URL', 'gp_lang' ), 'type' => 'upload' ),
									
	array( 'type' => 'close' ),
	
	
	'format_settings' => array( 'name' => 'format_settings', 'type' => 'open', 'title' => __( 'Format Settings', 'gp_lang' ), 'desc' => __( 'Controls the general formatting on this page.', 'gp_lang' ) ),

		'_gp_layout' => array( 'name' => '_gp_layout', 'title' => __( 'Page Layout', 'gp_lang' ), 'options' => array( 'default' => '', 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_post_layout' ), 'type' => 'select' ),
		
		'_gp_sidebar' => array( 'name' => '_gp_sidebar', 'title' => __( 'Sidebar', 'gp_lang' ), 'std' => 'default', 'placeholder' => get_option( 'gp_post_sidebar' ), 'type' => 'select_sidebar' ),
						
	array( 'type' => 'close' ),
	

	'image_settings' => array( 'name' => 'image_settings', 'type' => 'open', 'title' => __( 'Image Settings', 'gp_lang' ), 'desc' => __( 'Controls the featured image displayed on this page.', 'gp_lang' ) ),

		'_gp_featured_image' => array( 'name' => '_gp_featured_image', 'title' => __( 'Featured Image', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_post_featured_image' ), 'type' => 'radio' ),	
		
		array( 'type' => 'option_open', 'title' => __( 'Image Dimensions', 'gp_lang' ) ),
		
			'_gp_image_width' => array( 'name' => '_gp_image_width', 'type' => 'text', 'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X', 'size' => 'small', 'placeholder' => get_option( 'gp_post_image_width' ), 'stripped' => 'true' ),
				
			'_gp_image_height' => array( 'name' => '_gp_image_height', 'type' => 'text', 'details' => 'px', 'placeholder' => get_option( 'gp_post_image_height' ), 'size' => 'small', 'stripped' => 'true' ),	
	
		array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),
			
		'_gp_hard_crop' => array( 'name' => '_gp_hard_crop', 'title' => __( 'Hard Crop', 'gp_lang' ), 'desc' => __( 'Image is cropped even if it is smaller than the dimensions you want to crop it to.', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_post_hard_crop' ), 'type' => 'radio' ),
				
		'_gp_image_wrap' => array( 'name' => '_gp_image_wrap', 'title' => __( 'Image Wrap', 'gp_lang' ), 'desc' => __( 'The page content wraps around the featured image.', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_post_image_wrap' ), 'type' => 'radio' ),
						
	array( 'type' => 'close' ),
	
		
	);

	return apply_filters( '_gp_post_meta_boxes', $meta_boxes );
}


/////////////////////////////////////// Page Settings ///////////////////////////////////////


function gp_page_meta_boxes() {

	$meta_boxes = array( 


	'layerslider_settings' => array( 'name' => 'layerslider_settings', 'type' => 'open', 'title' => __( 'Slider Settings', 'gp_lang' ), 'desc' => __( 'Controls the "Homepage - LayerSlider" page template.', 'gp_lang' ) ),

		'_gp_layerslider_id' => array( 'name' => '_gp_layerslider_id', 'title' => __( 'Slider', 'gp_lang' ), 'desc' => __( 'Select a LayerSlider you <a href="' . admin_url( 'admin.php?page=layerslider' ) . '">imported or created</a>.', 'gp_lang' ), 'std' => '1', 'type' => 'select_layerslider' ),

	array( 'type' => 'close' ),


	'flexslider_settings' => array( 'name' => 'flexslider_settings', 'type' => 'open', 'title' => __( 'Slider Settings', 'gp_lang' ), 'desc' => __( 'Controls the "Homepage - FlexSlider" page template.', 'gp_lang' ) ),

		'_gp_flexslider_id' => array( 'name' => '_gp_flexslider_id', 'title' => __( 'Slider', 'gp_lang' ), 'desc' => __( 'Select a FlexSlider you <a href="' . admin_url( 'edit-tags.php?taxonomy=gp_slides&post_type=gp_slide' ) . '">created or imported</a>.', 'gp_lang' ), 'tax' => 'gp_slides', 'type' => 'select_taxonomy' ),

		'_gp_slide_timeout' => array( 'name' => '_gp_slide_timeout', 'title' => __( 'Slider Timeout', 'gp_lang' ), 'desc' => __( 'The number of seconds between each slide transition.', 'gp_lang' ), 'type' => 'text', 'size' => 'small', 'details' => 'seconds', 'std' => '6' ),


		array( 'type' => 'option_open', 'title' => __( 'Slider Dimensions', 'gp_lang' ) ),
	
			'_gp_slider_width' => array( 'name' => '_gp_slider_width', 'type' => 'text', 'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X', 'size' => 'small', 'std' => '1040', 'stripped' => 'true' ),
			
			'_gp_slider_height' => array( 'name' => '_gp_slider_height', 'type' => 'text', 'details' => 'px', 'size' => 'small', 'std' => '500', 'stripped' => 'true' ),	

		array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),
		
	array( 'type' => 'close' ),

			
	'blog_settings' => array( 'name' => 'blog_settings', 'type' => 'open', 'title' => __( 'Blog Settings', 'gp_lang' ), 'desc' => __( 'Controls the "Blog" page templates.', 'gp_lang' ) ),

		'_gp_blog_cats' => array( 'name' => '_gp_blog_cats', 'title' => __( 'Categories', 'gp_lang' ), 'desc' => __( 'Enter the ID numbers of the categories you want to include or exclude, separating each ID with a comma e.g. 33,74,25. Add a minus before an ID to exclude it e.g. -33,-74,-25. Hover your mouse over the category names on the <a href="' . admin_url( 'edit-tags.php?taxonomy=category') . '" target="_blank">category page</a> to reveal the URL which contains the ID numbers.', 'gp_lang' ), 'type' => 'text', 'std' => '' ),
		
		'_gp_posts_per_page' => array( 'name' => '_gp_posts_per_page', 'title' => __( 'Posts Per Page', 'gp_lang' ), 'desc' => __( 'The number of posts per page.', 'gp_lang' ), 'type' => 'text', 'std' => '4', 'size' => 'small' ),

	array( 'type' => 'close' ),
	

	'portfolio_settings' => array( 'name' => 'portfolio_settings', 'type' => 'open', 'title' => __( 'Portfolio Settings', 'gp_lang' ), 'desc' => __( 'Controls the "Portfolio" page template.', 'gp_lang' ) ),

		'_gp_portfolio_cats' => array( 'name' => '_gp_portfolio_cats', 'title' => __( 'Categories', 'gp_lang' ), __('Enter the ID numbers of the categories you want to include or exclude, separating each ID with a comma e.g. 33,74,25. Add a minus before an ID to exclude it e.g. -33,-74,-25. Hover your mouse over the category names on the <a href="' . admin_url( 'edit-tags.php?taxonomy=gp_portfolios&post_type=gp_portfolio_item' ) . '" target="_blank">category page</a> to reveal the URL which contains the ID numbers.', 'gp_lang'), 'type' => 'text', 'std' => '' ),

	array( 'type' => 'close' ),
	
		
	'format_settings' => array( 'name' => 'format_settings', 'type' => 'open', 'title' => __( 'Format Settings', 'gp_lang' ), 'desc' => __( 'Controls the general formatting  on this page.', 'gp_lang' ) ),

		'_gp_layout' => array( 'name' => '_gp_layout', 'title' => __( 'Page Layout', 'gp_lang' ), 'options' => array( 'default' => '', 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_page_layout' ), 'type' => 'select' ),		
		
		'_gp_sidebar' => array( 'name' => '_gp_sidebar', 'title' => __( 'Sidebar', 'gp_lang' ), 'std' => 'default', 'placeholder' => get_option( 'gp_page_sidebar' ), 'type' => 'select_sidebar' ),
						
	array( 'type' => 'close' ),
	
	
	'image_settings' => array( 'name' => 'image_settings', 'type' => 'open', 'title' => __( 'Image Settings', 'gp_lang' ), 'desc' => __( 'Controls the featured image displayed on this page.', 'gp_lang' ) ),

		'_gp_featured_image' => array( 'name' => '_gp_featured_image', 'title' => __( 'Featured Image', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_page_featured_image' ), 'type' => 'radio' ),	
		
		array( 'type' => 'option_open', 'title' => __( 'Image Dimensions', 'gp_lang' ) ),
		
			'_gp_image_width' => array( 'name' => '_gp_image_width', 'type' => 'text', 'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X', 'size' => 'small', 'placeholder' => get_option( 'gp_page_image_width' ), 'stripped' => 'true' ),
				
			'_gp_image_height' => array( 'name' => '_gp_image_height', 'type' => 'text', 'details' => 'px', 'size' => 'small', 'placeholder' => get_option( 'gp_page_image_height' ), 'stripped' => 'true' ),	
	
		array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),

		'_gp_hard_crop' => array( 'name' => '_gp_hard_crop', 'title' => __( 'Hard Crop', 'gp_lang' ), 'desc' => __( 'Image is cropped even if it is smaller than the dimensions you want to crop it to.', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_page_hard_crop' ), 'type' => 'radio' ),
	
		'_gp_image_wrap' => array( 'name' => '_gp_image_wrap', 'title' => __( 'Image Wrap', 'gp_lang' ), 'desc' => __( 'The page content wraps around the featured image.', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_page_image_wrap' ), 'type' => 'radio' ),
						
	array( 'type' => 'close' ),
	
	
	'title_settings' => array( 'name' => 'title_settings', 'type' => 'open', 'title' => __( 'Page Title Settings', 'gp_lang' ), 'desc' => __( 'Controls the page title display.', 'gp_lang' ) ),
				
		'_gp_title_header' => array( 'name' => '_gp_title_header', 'title' => __( 'Page Title Header', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_page_title_header' ), 'type' => 'radio' ),

		'_gp_title_header_image' => array( 'name' => '_gp_title_header_image', 'title' => __( 'Page Title Image', 'gp_lang' ), 'type' => 'upload' ),
		
		'_gp_title' => array( 'name' => '_gp_title', 'title' => __( 'Page Title', 'gp_lang' ), 'desc' => __( 'The page title ( if left blank the original page title will be used ).', 'gp_lang' ), 'type' => 'text' ),
				
		'_gp_subtitle' => array( 'name' => '_gp_subtitle', 'title' => __( 'Page Subtitle', 'gp_lang' ), 'type' => 'text' ),

		'_gp_title_header_color' => array( 'name' => '_gp_title_header_color', 'title' => __( 'Page Title Color', 'gp_lang' ), 'desc' => __( 'Color of this page title.', 'gp_lang' ), 'placeholder' => get_option( 'gp_page_title_color' ), 'type' => 'colorpicker' ),
				
		'_gp_title_header_padding' => array( 'name' => '_gp_title_header_padding', 'title' => __( 'Page Title Height', 'gp_lang' ), 'desc' => __( 'Padding on this page title ( supports px, em, % ).', 'gp_lang' ), 'placeholder' => get_option( 'gp_page_title_height' ), 'type' => 'text' ),

		'_gp_title_header_parallax' => array( 'name' => '_gp_title_header_parallax', 'title' => __( 'Parallax Page Title', 'gp_lang' ), 'desc' => __( 'Parallax scroll effect on this page title image.', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_page_title_header_parallax' ), 'type' => 'radio' ),

	array( 'type' => 'close' ),
		
	
	);

	return apply_filters( '_gp_page_meta_boxes', $meta_boxes );
}


/////////////////////////////////////// Portfolio Settings ///////////////////////////////////////


function gp_portfolio_meta_boxes() {

	$meta_boxes = array( 
	
	
	'format_settings' => array( 'name' => 'format_settings', 'type' => 'open', 'title' => __( 'Format Settings', 'gp_lang' ), 'desc' => __( 'Controls the general formatting  on this page.', 'gp_lang' ) ),

		'_gp_layout' => array( 'name' => '_gp_layout', 'title' => __( 'Page Layout', 'gp_lang' ), 'options' => array( 'default' => '', 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_portfolio_item_layout' ), 'type' => 'select' ),
		
		'_gp_sidebar' => array( 'name' => '_gp_sidebar', 'title' => __( 'Sidebar', 'gp_lang' ), 'std' => 'default', 'placeholder' => get_option( 'gp_portfolio_item_sidebar' ), 'type' => 'select_sidebar' ),

	array( 'type' => 'close' ),


	'image_slider_settings' => array( 'name' => 'image_slider_settings', 'type' => 'open', 'title' => __( 'Image/Slider Settings', 'gp_lang' ), 'desc' => __( 'Controls the featured image or slider displayed on this page.', 'gp_lang' ) ),	

		'_gp_type' => array( 'name' => '_gp_type', 'title' => __( 'Image/Slider Type', 'gp_lang' ), 'options' => array( 'default' => '', 'left-image' => __( 'Left Featured Image', 'gp_lang' ), 'fullwidth-image' => __( 'Fullwidth Featured Image', 'gp_lang' ), 'left-slider' => __( 'Left Slider', 'gp_lang' ), 'fullwidth-slider' => __( 'Fullwidth Slider', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_portfolio_item_type' ), 'type' => 'select' ),

		'_gp_gallery_slider' => array( 'name' => '_gp_gallery_slider', 'title' => __( 'Gallery Slider', 'gp_lang' ), 'type' => 'gallery_upload' ),
						
		array( 'type' => 'option_open', 'title' => __( 'Image/Slider Dimensions', 'gp_lang' ) ),
		
			'_gp_image_width' => array( 'name' => '_gp_image_width', 'type' => 'text', 'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X', 'size' => 'small', 'placeholder' => get_option( 'gp_portfolio_item_image_width' ), 'stripped' => 'true' ),
				
			'_gp_image_height' => array( 'name' => '_gp_image_height', 'type' => 'text', 'details' => 'px', 'size' => 'small', 'placeholder' => get_option( 'gp_portfolio_item_image_height' ), 'stripped' => 'true' ),	
	
		array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),
		
		'_gp_hard_crop' => array( 'name' => '_gp_hard_crop', 'title' => __( 'Hard Crop', 'gp_lang' ), 'desc' => __( 'Image is cropped even if it is smaller than the dimensions you want to crop it to.', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_portfolio_item_hard_crop' ), 'type' => 'radio' ),

		'_gp_image_size' => array( 'name' => '_gp_image_size', 'title' => __( 'Image Size (Masonry Portfolio Page)', 'gp_lang' ), 'desc' => __( 'Size of the image when displayed on a masonry portfolio page.', 'gp_lang' ), 'options' => array( 'regular' => __( 'Regular', 'gp_lang' ), 'wide' => __( 'Wide', 'gp_lang' ), 'tall' => __( 'Tall', 'gp_lang' ), 'large' => __( 'Large', 'gp_lang' ) ), 'std' => 'regular', 'type' => 'select' ),	
						
	array( 'type' => 'close' ),


	'link_settings' => array( 'name' => 'link_settings', 'type' => 'open', 'title' => __( 'Link  Settings', 'gp_lang' ), 'desc' => __( 'Controls the external portfolio link for this page.', 'gp_lang' ) ),

		'_gp_link' => array( 'name' => '_gp_link', 'title' => __( 'Link', 'gp_lang' ), 'type' => 'text', 'std' => 'http://' ),
		
		'_gp_link_target' => array( 'name' => '_gp_link_target', 'title' => __( 'Link Target', 'gp_lang' ), 'type' => 'radio', 'options' => array( 'default' => '', '_blank' => __( 'New Window', 'gp_lang' ), '_self' => __( 'Same Window', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_portfolio_item_link_target' ) ),
								
	array( 'type' => 'close' ),
	
	
	'title_settings' => array( 'name' => 'title_settings', 'type' => 'open', 'title' => __( 'Page Title Settings', 'gp_lang' ), 'desc' => __( 'Controls the page title display.', 'gp_lang' ) ),
				
		'_gp_title_header' => array( 'name' => '_gp_title_header', 'title' => __( 'Page Title Header', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_portfolio_item_title_header' ), 'type' => 'radio' ),

		'_gp_title_header_image' => array( 'name' => '_gp_title_header_image', 'title' => __( 'Page Title Image', 'gp_lang' ), 'type' => 'upload' ),
		
		'_gp_title' => array( 'name' => '_gp_title', 'title' => __( 'Page Title', 'gp_lang' ), 'desc' => __( 'The page title ( if left blank the original page title will be used ).', 'gp_lang' ), 'type' => 'text' ),
				
		'_gp_subtitle' => array( 'name' => '_gp_subtitle', 'title' => __( 'Page Subtitle', 'gp_lang' ), 'type' => 'text' ),

		'_gp_title_header_color' => array( 'name' => '_gp_title_header_color', 'title' => __( 'Page Title Color', 'gp_lang' ), 'desc' => __( 'Color of this page title.', 'gp_lang' ), 'placeholder' => get_option( 'gp_portfolio_item_title_color' ), 'type' => 'colorpicker' ),
				
		'_gp_title_header_padding' => array( 'name' => '_gp_title_header_padding', 'title' => __( 'Page Title Height', 'gp_lang' ), 'desc' => __( 'Padding on this page title ( supports px, em, % ).', 'gp_lang' ), 'placeholder' => get_option( 'gp_portfolio_item_title_height' ), 'type' => 'text' ),

		'_gp_title_header_parallax' => array( 'name' => '_gp_title_header_parallax', 'title' => __( 'Parallax Page Title', 'gp_lang' ), 'desc' => __( 'Parallax scroll effect on this page title image.', 'gp_lang' ), 'options' => array( 'default' => '', 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_portfolio_item_title_header_parallax' ), 'type' => 'radio' ),

	array( 'type' => 'close' ),
			
	
	);

	return apply_filters( '_gp_portfolio_meta_boxes', $meta_boxes );
}


/////////////////////////////////////// Product Settings ///////////////////////////////////////


function gp_product_meta_boxes() {

	$meta_boxes = array( 
	
	
	'format_settings' => array( 'name' => 'format_settings', 'type' => 'open', 'title' => __( 'Format Settings', 'gp_lang' ), 'desc' => __( 'Controls the general formatting  on this page.', 'gp_lang' ) ),

		'_gp_layout' => array( 'name' => '_gp_layout', 'title' => __( 'Page Layout', 'gp_lang' ), 'options' => array( 'default' => '', 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ), 'std' => 'default', 'placeholder' => get_option( 'gp_product_layout' ), 'type' => 'select' ),
		
		'_gp_sidebar' => array( 'name' => '_gp_sidebar', 'title' => __( 'Sidebar', 'gp_lang' ), 'std' => 'default', 'placeholder' => get_option( 'gp_product_sidebar' ), 'type' => 'select_sidebar' ),

	array( 'type' => 'close' ),
			
	
	);

	return apply_filters( '_gp_product_meta_boxes', $meta_boxes );
}


/////////////////////////////////////// Slide Settings ///////////////////////////////////////


function gp_slide_meta_boxes() {

	$meta_boxes = array( 


	'link_settings' => array( 'name' => 'link_settings', 'type' => 'open', 'title' => __( 'Link  Settings', 'gp_lang' ), 'desc' => __( 'Controls the slide link for this page.', 'gp_lang' ) ),

		'_gp_link' => array( 'name' => '_gp_link', 'title' => __( 'Link', 'gp_lang' ), 'type' => 'text', 'std' => 'http://' ),
		
		'_gp_link_target' => array( 'name' => '_gp_link_target', 'title' => __( 'Link Target', 'gp_lang' ), 'type' => 'radio', 'options' => array( '_self' => __( 'Same Window', 'gp_lang' ), '_blank' => __( 'New Window', 'gp_lang' ) ), 'std' => '_self' ),
								
	array( 'type' => 'close' ),
			
	
	);

	return apply_filters( '_gp_slide_meta_boxes', $meta_boxes );
}


/////////////////////////////////////// Meta Fields ///////////////////////////////////////


function gp_meta_boxes() {

	global $post;
	
	if ( get_post_type() == 'post' ) {
		$meta_boxes = gp_post_meta_boxes();	
	} elseif ( get_post_type() == 'gp_portfolio_item' ) {
		$meta_boxes = gp_portfolio_meta_boxes();
	} elseif ( get_post_type() == 'product' ) {
		$meta_boxes = gp_product_meta_boxes();
	} elseif ( get_post_type() == 'gp_slide' ) {
		$meta_boxes = gp_slide_meta_boxes();					
	} else {
		$meta_boxes = gp_page_meta_boxes();
	}
	
	foreach ( $meta_boxes as $meta ) {
		if ( isset( $meta['name'] ) ) {
			$value = get_post_meta( $post->ID, $meta['name'], true );
		}
		if ( $meta['type'] == 'open' ) {
			get_meta_open( $meta, $value );		
		} elseif ( $meta['type'] == 'close' ) {
			get_meta_close( $meta, $value );	
		} elseif ( $meta['type'] == 'option_open' ) {
			get_meta_option_open( $meta, $value );		
		} elseif ( $meta['type'] == 'option_close' ) {
			get_meta_option_close( $meta, $value );	
		} elseif ( $meta['type'] == 'text' ) {
			get_meta_text( $meta, $value );				
		} elseif ( $meta['type'] == 'text' ) {
			get_meta_text( $meta, $value );	
		} elseif ( $meta['type'] == 'upload' ) {
			get_meta_upload( $meta, $value );	
		} elseif ( $meta['type'] == 'gallery_upload' ) {
			get_meta_gallery_upload( $meta, $value );					
		} elseif ( $meta['type'] == 'textarea' ) {
			get_meta_textarea( $meta, $value );
		} elseif ( $meta['type'] == 'select' ) {
			get_meta_select( $meta, $value );
		} elseif ( $meta['type'] == 'select_sidebar' ) {
			get_meta_select_sidebar( $meta, $value );
		} elseif ( $meta['type'] == 'select_layerslider' ) {
			get_meta_select_layerslider( $meta, $value );
		} elseif ( $meta['type'] == 'select_taxonomy' ) {
			get_meta_select_taxonomy( $meta, $value );									
		} elseif ( $meta['type'] == 'checkbox' ) {
			get_meta_checkbox( $meta, $value );	
		} elseif ( $meta['type'] == 'radio' ) {
			get_meta_radio( $meta, $value );						
		} elseif ( $meta['type'] == 'colorpicker' ) {
			get_meta_colorpicker( $meta, $value );				
		}
	}	
	
} function get_meta_open( $args = array(), $value = false ) {
extract( $args ); ?>
	
	<div class="meta-settings hidden" id="<?php echo $name; ?>">
			
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />

		<?php if ( isset( $title ) ) { ?><h2><?php echo $title; ?></h2><?php } ?>
	
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc gp-header-desc"><?php echo $desc; ?></div><?php } ?>
	
	
<?php } function get_meta_close( $args = array(), $value = false ) {
extract( $args ); ?>

		<input type="hidden" name="_noncename" id="_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		
	</div>
	
	
<?php } function get_meta_option_open( $args = array(), $value = false ) {
extract( $args ); ?>

	<div id="meta-box" class="gp-option gp-option-open">		

		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>	

		<input type="hidden" name="_noncename" id="_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />		
		
	
<?php } function get_meta_option_close( $args = array(), $value = false ) {
extract( $args ); ?>
	
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="_noncename" id="_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
					
	</div>
	
				
<?php } function get_meta_text( $args = array(), $value = false, $std = '', $placeholder = '', $stripped = 'false', $size = '' ) {
extract( $args ); ?>

	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-text<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">	
		
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>
			
		<input type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="<?php if ( $value != '' ) { echo esc_html( $value, 1 ); } else { echo $std; } ?>" placeholder="<?php echo $placeholder; ?>" size="<?php if ( $size == 'small' ) { ?>4<?php } else { ?>30<?php } ?>" /><?php if ( isset( $details ) ) { ?> <span><?php echo $details; ?></span><?php } ?>		
		
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />		
	
	</div>


<?php } function get_meta_upload( $args = array(), $value = false, $std = '', $stripped = 'false' ) {
extract( $args ); ?>

	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-upload<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>
		
		<input type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" class="upload" value="<?php if ( $value != '' ) { echo esc_html( $value, 1 ); } else { echo $std; } ?>" size="30" />
		
		<input type="button" id="<?php echo $name; ?>_button" class="gp-upload-button button" value="<?php _e( 'Upload', 'gp_lang' ); ?>" />
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	
	</div>
	
	
<?php } function get_meta_gallery_upload( $args = array(), $value = false, $std = '', $stripped = 'false' ) {
extract( $args ); global $post; ?>

	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-gallery-upload <?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">
		
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>

		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>	

		<div id="gallery-images-container">
		
			<ul class="gallery-images">
				
				<?php
				
				if ( metadata_exists( 'post', $post->ID, $name ) ) {
					$image_gallery = get_post_meta( $post->ID, $name, true );
				} else {
					$image_gallery = '';
				}
				
				$attachments = array_filter( explode( ',', $image_gallery ) );

				if ( $attachments )
					foreach ( $attachments as $attachment_id ) {
						echo '<li class="image" data-attachment_id="' . esc_attr( $attachment_id ) . '">
							' . wp_get_attachment_image( $attachment_id, 'thumbnail' ) . '
							<a href="#" class="delete tips" data-tip="' . __( 'Delete image', 'gp_lang' ) . '"></a>
						</li>';
					}
				?>
				
			</ul>

			<input type="hidden" id="<?php echo $name; ?>" name="<?php echo $name; ?>" class="gp-gallery" value="<?php echo esc_attr( $image_gallery ); ?>" />
			
		</div>
		
		<span class="add-gallery-images hide-if-no-js">
			<input type="button" class="button" value="<?php _e( 'Add Images', 'gp_lang' ); ?>" data-choose="<?php _e( 'Add Images', 'gp_lang' ); ?>" data-update="<?php _e( 'Add Image', 'gp_lang' ); ?>" data-delete="<?php _e( 'Delete Image', 'gp_lang' ); ?>" data-text="<?php _e( 'Delete', 'gp_lang' ); ?>">
		</span>

		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	
	</div>
		
		
<?php } function get_meta_textarea( $args = array(), $value = false, $std = '', $placeholder = '', $stripped = 'false' ) {
extract( $args ); ?>

	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-textarea<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">	
		
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>
		
		<textarea name="<?php echo $name; ?>" id="<?php echo $name; ?>" cols="60" rows="4" tabindex="30" placeholder="<?php echo $placeholder; ?>"><?php if ( $value != '' ) { echo esc_html( $value, 1 ); } else { echo $std; } ?></textarea>
		
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	
	</div>


<?php } function get_meta_checkbox( $args = array(), $value = false, $std = '', $stripped = 'false' ) {
extract( $args ); ?>

	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-checkbox<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if ( $value != '' ) { $checked = 'checked="checked"'; } else { if ( $std === 'true' ) { $checked = 'checked="checked"'; } else { $checked = ''; } } ?>
		
		<input type="checkbox" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="true" <?php echo $checked; ?> />
		
		<?php if ( isset( $title ) ) { ?><strong><?php echo $title; ?></strong><?php } ?>
		
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />		
	
	</div>
	

<?php } function get_meta_radio( $args = array(), $value = false, $std = '', $placeholder = '', $stripped = 'false' ) {
extract( $args ); ?>
	
	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-radio<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>
					
		<?php foreach ( $options as $key => $option ) { ?>
			
			<div class="gp-radio-button">
			
				<?php if($key == 'default') { ?>
					<input type="radio" name="<?php echo $name; ?>" id="<?php echo $name . $key; ?>" value="default" <?php if ( $key == 'default' ) { echo ' checked="checked"'; } ?>><label for="<?php echo $name . '_' . $key; ?>"><?php echo ucwords( str_replace( '-', ' ', $placeholder ) ) . __(' (Default)', 'gp_lang'); ?></label>
				<?php } elseif ( $value != '' ) { ?>
					<input type="radio" name="<?php echo $name; ?>" id="<?php echo $name . $key; ?>" value="<?php echo $key; ?>" <?php if ( htmlentities( $value, ENT_QUOTES ) == $key ) { echo ' checked="checked"'; } ?>><label for="<?php echo $name . '_' . $key; ?>"><?php echo $option; ?></label>
				<?php } else { ?>
					<input type="radio" name="<?php echo $name; ?>" id="<?php echo $name . $key; ?>" value="<?php echo $key; ?>" <?php if ( $std == $key ) { echo ' checked="checked"'; } ?>><label for="<?php echo $name . '_' . $key; ?>"><?php echo $option; ?></label>
				<?php } ?>
			
			</div>
							
		<?php } ?>
				
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	
	</div>

			
<?php } function get_meta_select( $args = array(), $value = false, $std = '', $placeholder = '', $stripped = 'false' ) {
extract( $args ); ?>
	
	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-select<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>
		
		<select name="<?php echo $name; ?>" id="<?php echo $name; ?>">
						
			<?php foreach ( $options as $key => $option ) { ?>
			
				<?php if($key == 'default') { ?>
					<option value="default" <?php if ( htmlentities( $value, ENT_QUOTES ) == 'default' ) echo ' selected="selected"'; ?>><?php echo ucwords( str_replace( '-', ' ', $placeholder ) ) . __(' (Default)', 'gp_lang'); ?></option>
				<?php } elseif ( $value != '' ) { ?>
					<option value="<?php echo $key; ?>" <?php if ( htmlentities( $value, ENT_QUOTES ) == $key ) echo ' selected="selected"'; ?>><?php echo $option; ?></option>
				<?php } else { ?>
					<option value="<?php echo $key; ?>" <?php if ( $std == $key ) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
				<?php } ?>
					
			<?php } ?>
			
		</select>
		
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	
	</div>


<?php } function get_meta_select_sidebar( $args = array(), $value = false, $std = '', $placeholder = '', $stripped = 'false' ) {
extract( $args ); global $wp_registered_sidebars; ?>

	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-sidebar-select<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">
		
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>
		
		<?php 		
		$placeholder = str_replace( 'gp-', '', $placeholder );
		$placeholder = ucwords( str_replace( '-', ' ', $placeholder ) );
		?>
		
		<select name="<?php echo $name; ?>" id="<?php echo $name; ?>">
			
			<option value="default" <?php if( htmlentities( $value, ENT_QUOTES) == 'default' ) echo ' selected="selected"'; ?>><?php echo $placeholder . __(' (Default)', 'gp_lang'); ?></option>
			
			<?php $sidebars = $wp_registered_sidebars;
			if ( is_array( $sidebars ) && !empty( $sidebars ) ) { foreach ( $sidebars as $sidebar ) { if ( $value != '' ) { ?>
				<option value="<?php echo $sidebar['id']; ?>"<?php if ( $value == $sidebar['id'] ) { echo ' selected="selected"'; } ?>><?php echo $sidebar['name']; ?></option>
			<?php } else { ?>
				<option value="<?php echo $sidebar['id']; ?>"<?php if ( $std == $sidebar['id'] ) { echo ' selected="selected"'; } ?>><?php echo $sidebar['name']; ?></option>
			<?php }}} ?>
			
		</select>
		
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	
	</div>


<?php } function get_meta_select_layerslider( $args = array(), $value = false, $std = '', $stripped = 'false' ) {
extract( $args ); ?>

	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-sidebar-select<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">
		
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>
		
		<select name="<?php echo $name; ?>" id="<?php echo $name; ?>">

			<?php if ( function_exists( 'layerslider' ) ) {
			
				$sliders = LS_Sliders::find( array( 'data' => true ) );
			
				if ( !empty( $sliders ) ) {
			
					foreach ($sliders as $key => $item ) {
			
						 if ( $value != '' ) { ?>
							<option value="<?php echo $item['id']; ?>"<?php if ( $value == $item['id'] ) { echo ' selected="selected"'; } ?>><?php echo apply_filters( 'ls_slider_title', $item['name'], 40 ); ?></option>
						<?php } else { ?>
							<option value="<?php echo $item['id']; ?>"<?php if ( $std == $item['id'] ) { echo ' selected="selected"'; } ?>><?php echo apply_filters( 'ls_slider_title', $item['name'], 40 ); ?></option>
						<?php }
				
					}
			
				} 
			
			} ?>
			
		</select>
		
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	
	</div>


<?php } function get_meta_select_taxonomy( $args = array(), $value = false, $std = '', $stripped = 'false' ) {
extract( $args ); ?>

	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-sidebar-select<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">
		
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>
		
		<select name="<?php echo $name; ?>" id="<?php echo $name; ?>">

			<?php $terms = get_terms( $tax, 'hide_empty=false' );
			
			if ( !empty( $terms ) ) {
			
				foreach( $terms as $term ) {
			
					 if ( $value != '' ) { ?>
						<option value="<?php echo $term->slug; ?>"<?php if ( $value == $term->slug ) { echo ' selected="selected"'; } ?>><?php echo $term->name; ?></option>
					<?php } else { ?>
						<option value="<?php echo $term->slug; ?>"<?php if ( $std == $term->slug ) { echo ' selected="selected"'; } ?>><?php echo $term->name; ?></option>
					<?php }
				
				}
			
			} else { ?>
			
				<option disabled><?php _e( 'No Sliders Created', 'gp_lang' ); ?></option>

			<?php } ?>
			
		</select>
		
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	
	</div>		


<?php } function get_meta_colorpicker( $args = array(), $value = false, $std = '', $placeholder = '', $stripped = 'false' ) {
extract( $args ); ?>

	<div id="meta-box-<?php echo $name; ?>" class="gp-option gp-colorpicker<?php if ( $stripped == 'true' ) { ?> gp-stripped<?php } ?>">
		
		<script>
			jQuery( document ).ready( function( $ ) { 
				$( '#<?php echo $name; ?>' ).wpColorPicker();
			} );
		</script>
		
		<?php if ( isset( $title ) ) { ?><h4><?php echo $title; ?></h4><?php } ?>
		
		<input type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="<?php if ( $value != '' ) { echo esc_html( $value, 1 ); } else { echo $std; } ?>" placeholder="<?php echo $placeholder; ?>" />	
		
		<div id="<?php echo $name; ?>_picker"></div>
		
		<?php if ( isset( $desc ) ) { ?><div class="gp-option-desc"><?php echo $desc; ?></div><?php } ?>
		
		<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	
	</div>
	

<?php }

if ( is_admin() && ( $pagenow == "post.php" OR $pagenow == "post-new.php" ) ) {

	function gp_admin_styles() {
		wp_enqueue_style( 'gp-admin', get_template_directory_uri() . '/lib/admin/css/admin.css' );	
		wp_enqueue_style( 'wp-color-picker' );	
	}
	add_action( 'admin_enqueue_scripts', 'gp_admin_styles' );
	
	function gp_admin_scripts() {	
		wp_enqueue_script( 'wp-color-picker' );
		wp_enqueue_script( 'gp-uploader', get_template_directory_uri() . '/lib/admin/scripts/uploader.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'gp-dependencies', get_template_directory_uri() . '/lib/admin/scripts/jquery.dependencies.js', array( 'jquery' ), '', true );
	}	
	add_action( 'admin_enqueue_scripts', 'gp_admin_scripts' );
	
}

function gp_save_meta_data( $post_id ) {

	global $post;

	if ( isset( $_POST['post_type'] ) && 'post' == $_POST['post_type'] ) {
		$meta_boxes = array_merge( gp_post_meta_boxes() );
	} elseif ( isset( $_POST['post_type'] ) && 'gp_portfolio_item' == $_POST['post_type'] ) {
		$meta_boxes = array_merge( gp_portfolio_meta_boxes() );	
	} elseif ( isset( $_POST['post_type'] ) && 'product' == $_POST['post_type'] ) {
		$meta_boxes = array_merge( gp_product_meta_boxes() );	
	} elseif ( isset( $_POST['post_type'] ) && 'gp_slide' == $_POST['post_type'] ) {
		$meta_boxes = array_merge( gp_slide_meta_boxes() );					
	} else {
		$meta_boxes = array_merge( gp_page_meta_boxes() );
	}
				
	foreach ( $meta_boxes as $meta_box ) {
		
		if ( !isset( $_POST[$meta_box['name'] . '_noncename'] ) OR !wp_verify_nonce( $_POST[$meta_box['name'] . '_noncename'], plugin_basename( __FILE__ ) ) ) {
			return $post_id;
		}
		
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}
		      
		if ( !current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}
					
		$data = sanitize_text_field( $_POST[$meta_box['name']] );

		if ( get_post_meta( $post_id, $meta_box['name'] ) == '' ) {
			add_post_meta( $post_id, $meta_box['name'], $data, true );
		} elseif ( $data != get_post_meta( $post_id, $meta_box['name'], true ) ) {
			update_post_meta( $post_id, $meta_box['name'], $data );
		} elseif ( $data == '' ) {
			delete_post_meta( $post_id, $meta_box['name'], get_post_meta( $post_id, $meta_box['name'], true ) );
		}
		
	}
	
}

?>