<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<?php require( gp_inc . 'options.php' ); ?>
<?php require( gp_inc . 'page-settings.php' ); ?>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<?php if ( $gp_responsive == 'gp-responsive' ) { ?><meta name="viewport" content="width=device-width, initial-scale=1"><?php } ?>
<title><?php bloginfo( 'name' ); ?> | <?php if ( is_home() OR is_front_page() ) { bloginfo( 'description' ); } else { wp_title( '' ); } ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if ( !is_page_template( 'blank-page.php' ) ) { ?>

	<div id="page-wrapper">

		<?php if ( $gp_header_layout == 'gp-header-3' ) { ?>
	
			<header id="top-header">
	
				<div class="container">

					<nav id="top-nav" class="nav">				
						<?php wp_nav_menu( array( 'theme_location' => 'top-nav', 'sort_column' => 'menu_order', 'container' => 'ul', 'fallback_cb' => 'null' ) ); ?>
					</nav>

					<?php get_template_part( 'social', 'icons' ); ?>
					
				</div>
		
			</header><!-- END TOP HEADER -->
	
		<?php } ?>

		<header id="header">

			<div class="container">
	
				<<?php if ( is_singular( 'post' ) OR ( isset( $gp_settings['title_header'] ) && $gp_settings['title_header'] == 'enable' ) ) { ?>div<?php } else { ?>h1<?php } ?> id="logo">
					<span class="logo-details"><?php bloginfo( 'name' ); ?> | <?php is_home() OR is_front_page() ? bloginfo( 'description' ) : wp_title( '' ); ?></span>
					<a href="<?php echo home_url(); ?>" title="<?php bloginfo( 'name' ); ?>">
						<img src="<?php if ( $gp_logo ) { echo $gp_logo; } else { echo get_template_directory_uri() . '/lib/images/logo1.png'; } ?>" alt="<?php bloginfo( 'name' ); ?>" width="<?php echo $gp_logo_width; ?>" height="<?php echo $gp_logo_height; ?>" />
					</a>

				</<?php if ( is_singular( 'post' ) OR ( isset( $gp_settings['title_header'] ) && $gp_settings['title_header'] == 'enable' ) ) { ?>div<?php } else { ?>h1<?php } ?>>

				<?php if ( has_nav_menu( 'header-nav' ) ) { ?>
				
					<nav id="main-nav" class="nav">				
						
						<?php wp_nav_menu( array( 'theme_location' => 'header-nav', 'sort_column' => 'menu_order', 'container' => 'ul', 'fallback_cb' => 'null' ) ); ?>
						
						<?php if ( $gp_search == 'enable' ) { ?><a id="search-button"></a><?php } ?>
						
						<?php if ( function_exists( 'is_woocommerce' ) && $gp_cart == 'enable' ) { echo gp_dropdown_cart(); } ?>
		
					</nav>
								
				<?php } ?><!-- END MAIN NAV -->
				
				<?php if ( has_nav_menu( 'header-nav' ) ) { ?>
					<a id="mobile-nav-button" class="mobile-button"><i class="fa fa-bars"></i></a>
				<?php } ?><!-- END MOBILE NAV BUTTON -->	

				<?php if ( function_exists( 'is_woocommerce' ) && $gp_cart == 'enable' && !is_cart() ) { global $woocommerce; ?>
					<a href="<?php echo $woocommerce->cart->get_cart_url(); ?>" id="mobile-cart-button" class="mobile-button" title="<?php _e( 'View your shopping cart', 'gp_lang' ); ?>"><i class="fa fa-shopping-cart"></i></a>			
				<?php } ?><!-- END MOBILE CART BUTTON -->

			</div>
	
		</header><!-- END HEADER -->

		<?php if ( $gp_header_layout != 'gp-header-2' ) { ?>
			<div id="fixed-header-padding"></div>
		<?php } ?>

		<?php if ( $gp_search == 'enable' ) { ?>
			<div id="desktop-search" class="search-outer">
				<div class="container">
					<?php get_search_form(); ?>
				</div>
			</div>
		<?php } ?><!-- END SEARCH FORM -->

		<nav id="mobile-nav">
			<?php if ( $gp_search == 'enable' ) { ?>
				<div id="mobile-search" class="search-outer">
					<?php get_search_form(); ?>
				</div>
			<?php } ?>
			<?php wp_nav_menu( array( 'theme_location' => 'header-nav', 'sort_column' => 'menu_order', 'container' => '', 'items_wrap' => '<ul class="menu">%3$s</ul>', 'fallback_cb' => 'null' ) ); ?>
		</nav><!-- END MOBILE MENU -->

<?php } ?>		