<?php require( gp_inc . 'options.php' ); global $gp_settings;

// Gallery Image IDs
$gallery_ids = array_filter( explode( ',', get_post_meta( get_the_ID(), '_gp_gallery_slider', true ) ) );	

if( $gallery_ids ) { ?>

	<div class="post-format-gallery-content gp-slider<?php if ( $gp_settings['image_wrap'] == 'enable' ) { ?> wrap<?php } ?>"> 
		 <ul class="slides">
			<?php foreach ( $gallery_ids as $image_id ) { ?>
				<li>
					<?php $image = aq_resize( wp_get_attachment_url( $image_id ), $gp_settings['image_width'], $gp_settings['image_height'], $gp_settings['hard_crop'], false, true ); ?>
					<?php if ( $gp_retina == 'enable' ) {
						$retina = aq_resize(wp_get_attachment_url( $image_id ),  $gp_settings['image_width'] * 2, $gp_settings['image_height'] * 2, $gp_settings['hard_crop'], false, true );
					} else {
						$retina = '';
					} ?>
					<img src="<?php echo $image[0]; ?>" data-rel="<?php echo $retina[0]; ?>" width="<?php echo $image[1]; ?>" height="<?php echo $image[2]; ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true); } else { the_title_attribute(); } ?>" class="wp-post-image" />			
				</li>
			<?php } ?>
		</ul>
	 </div>

	<script>
	jQuery( document ).ready( function( $ ) {
		'use strict';
		$( '.post-<?php the_ID(); ?> .gp-slider' ).flexslider( { 
			animation: 'fade',
			slideshowSpeed: 9999999,
			animationSpeed: 600,
			directionNav: true,			
			controlNav: false,			
			pauseOnAction: true, 
			pauseOnHover: false,
			prevText: '',
			nextText: ''
		});
	});
	</script>

<?php } else { ?>

<div class="entry-content">
	<?php the_content(); ?>
</div>

<?php } ?>