<?php require( gp_inc . 'options.php' ); global $gp_settings; ?>
		
<article <?php post_class(); ?>>

	<?php if ( is_single() ) { ?>

		<header class="entry-header post-header">
	
			<h1 class="entry-title"><?php the_title(); ?></h1>

			<?php if ( $gp_settings['meta_date'] == 'enable' OR $gp_settings['meta_author'] == 'enable' OR ( is_singular( 'post' ) && $gp_settings['meta_cats'] == 'enable' ) OR $gp_settings['meta_comments'] == 'enable' ) { ?>

				<div class="entry-meta">
	
					<?php if ( $gp_settings['meta_author'] == 'enable' ) { ?><span class="meta-author"><?php the_author_posts_link(); ?></span><?php } ?>
	
					<?php if ( $gp_settings['meta_date'] == 'enable' ) { ?><span class="meta-date"><?php the_time( get_option( 'date_format' ) ); ?></span><?php } ?>
	
					<?php if ( is_singular( 'post' ) && $gp_settings['meta_cats'] == 'enable') { ?><span class="meta-cats"><?php the_category( ', ' ); ?></span><?php } ?>

					<?php if ( $gp_settings['meta_comments'] == 'enable' ) { ?><span class="meta-comments"><?php comments_popup_link( __( 'No Comments', 'gp_lang' ), __( '1 Comment', 'gp_lang' ), __( '% Comments', 'gp_lang' ), 'comments-link', __( 'Comments Closed', 'gp_lang' ) ); ?></span><?php } ?>
											
				</div>

			<?php } ?><!-- END ENTRY META -->
		
		</header>

	<?php } ?><!-- END ENTRY HEADER -->

	<div class="entry-content">

		<?php if ( has_post_thumbnail() && $gp_settings['featured_image'] == 'enable' && get_post_format() == '0' ) { ?>

			<div class="post-thumbnail<?php if ( $gp_settings['image_wrap'] == 'enable' ) { ?> wrap<?php } ?>">
	
				<?php $image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), $gp_settings['image_width'], $gp_settings['image_height'], $gp_settings['hard_crop'], false, true ); ?>
				<?php if ( $gp_retina == 'enable' ) {
					$retina = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), $gp_settings['image_width'] * 2, $gp_settings['image_height'] * 2, $gp_settings['hard_crop'], false, true );
				} else {
					$retina = '';
				} ?>
	
				<img src="<?php echo $image[0]; ?>" data-rel="<?php echo $retina[0]; ?>" width="<?php echo $image[1]; ?>" height="<?php echo $image[2]; ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ); } else { the_title_attribute(); } ?>" class="wp-post-image" />
			
			</div>
	
		<?php } ?>	

		<?php get_template_part( 'entry', get_post_format() ); ?>
		
		<?php if ( $post->post_type == 'page' OR get_post_format() == '0' OR get_post_format() == 'audio' OR (get_post_format() == 'gallery' && ! has_shortcode( $post->post_content, 'gallery' ) ) OR get_post_format() == 'link' OR get_post_format() == 'video' ) { ?>

			<?php the_content(); ?>
		
		<?php } ?>
				
	</div><!-- END ENTRY CONTENT -->
	
	<?php wp_link_pages( 'before=<ul class="page-numbers single-nav">&pagelink=<span class="page-numbers">%</span>&after=</ul>' ); ?>		

	<?php if ( is_singular( 'post' ) && $gp_settings['meta_tags'] == 'enable' ) { ?>
		<?php the_tags( '<div class="meta-tags">', ' ', '</div>' ); ?>
	<?php } ?>

	<?php if ( isset( $gp_settings['author_info'] ) && $gp_settings['author_info'] == 'enable' ) { get_template_part( 'author', 'info' ); } ?>

	<?php if ( is_singular( 'post' ) && $gp_settings['related_items'] == 'enable' ) { get_template_part( 'related', 'posts' ); } ?>

	<?php if ( is_single() ) { comments_template(); } ?>

</article><!-- END ARTICLE -->