<?php
/*
Template Name: Blog - Masonry
*/
get_header(); global $gp_settings; ?>

<?php gp_page_header( get_the_ID() ); ?>

<div id="content-wrapper"<?php if ( $gp_settings['layout'] != 'fullwidth' ) { ?> class="container"<?php } ?>>

	<div id="content">
	
		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>		
			<?php the_content(); ?>
		<?php endwhile; endif; rewind_posts(); ?>			

		<?php 

		if ( get_query_var('paged') ) {
			$paged = get_query_var('paged');
		} elseif ( get_query_var('page') ) {
			$paged = get_query_var('page');
		} else {
			$paged = 1;
		}

		$args = array(
		'post_type'      => 'post',
		'cat' => get_post_meta( get_the_ID(), '_gp_blog_cats', true ),
		'posts_per_page' => get_post_meta( get_the_ID(), '_gp_posts_per_page', true ),
		'paged'          => $paged,
		);

		$featured_query = new wp_query( $args ); if ( $featured_query->have_posts() ) : ?>

			<div class="post-wrapper blog-masonry">
	
				<?php while ( $featured_query->have_posts() ) : $featured_query->the_post(); ?>

					<?php get_template_part( 'post', 'loop' ); ?>
					
				<?php endwhile; ?>

			</div><!-- END POST WRAPPER -->

			<?php gp_pagination( $featured_query->max_num_pages ); ?>

		<?php else : ?>

			<span class="error"><?php _e( 'No posts found.', 'gp_lang' ); ?></span>

		<?php endif; wp_reset_postdata(); ?>

	</div><!-- END CONTENT -->

	<?php get_sidebar(); ?>
	
</div><!-- END CONTENT WRAPPER -->

<?php get_footer(); ?>